<?php
/**
 * Database migration script to add payment tracking columns
 */

require_once("../../conn.php");

echo "<h2>Database Migration: Add Payment Tracking Columns</h2>";

// Add is_paid and paid_at columns to bet_rebates table
$alterQueries = [
    "ALTER TABLE bet_rebates ADD COLUMN is_paid TINYINT(1) DEFAULT 0",
    "ALTER TABLE bet_rebates ADD COLUMN paid_at TIMESTAMP NULL DEFAULT NULL",
    "ALTER TABLE bet_rebates ADD INDEX idx_is_paid (is_paid)",
    "ALTER TABLE bet_rebates ADD INDEX idx_paid_at (paid_at)"
];

$successCount = 0;
$errorCount = 0;

foreach ($alterQueries as $query) {
    if ($conn->query($query)) {
        echo "<p style='color: green;'>✓ " . htmlspecialchars($query) . "</p>";
        $successCount++;
    } else {
        $error = $conn->error;
        if (strpos($error, "Duplicate column name") !== false || strpos($error, "Duplicate key name") !== false) {
            echo "<p style='color: #856404;'>ℹ️ " . htmlspecialchars($query) . " (Already exists)</p>";
        } else {
            echo "<p style='color: red;'>✗ " . htmlspecialchars($query) . " - Error: " . htmlspecialchars($error) . "</p>";
            $errorCount++;
        }
    }
}

echo "<h3>Migration Summary</h3>";
echo "<ul>";
echo "<li><strong>Successful operations:</strong> $successCount</li>";
echo "<li><strong>Errors:</strong> $errorCount</li>";
echo "</ul>";

// Show current table structure
echo "<h3>Current bet_rebates Table Structure</h3>";
$structureQuery = "DESCRIBE bet_rebates";
$structureResult = $conn->query($structureQuery);

if ($structureResult) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr style='background: #f2f2f2;'>";
    echo "<th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th>";
    echo "</tr>";
    
    while ($row = $structureResult->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Default']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Extra']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>Error: Could not retrieve table structure</p>";
}

$conn->close();

echo "<p><strong>Migration complete!</strong> The database is now ready for the daily rebate payout cron job.</p>";
?>
